<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title><?php echo app('translator')->get('app.menu.payments'); ?></title>
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e(global_setting()->favicon_url); ?>">
    <meta name="theme-color" content="#ffffff">

    <style>
        body {
            margin: 0;
            font-family: Verdana, Arial, Helvetica, sans-serif;
        }

        .bg-grey {
            background-color: #F2F4F7;
        }

        .bg-white {
            background-color: #fff;
        }

        .border-radius-25 {
            border-radius: 0.25rem;
        }

        .p-25 {
            padding: 1.25rem;
        }

        .f-13 {
            font-size: 13px;
        }

        .f-14 {
            font-size: 14px;
        }

        .f-15 {
            font-size: 15px;
        }

        .f-21 {
            font-size: 21px;
        }

        .text-black {
            color: #28313c;
        }

        .text-grey {
            color: #616e80;
        }

        .font-weight-700 {
            font-weight: 700;
        }

        .text-uppercase {
            text-transform: uppercase;
        }

        .text-capitalize {
            text-transform: capitalize;
        }

        .line-height {
            line-height: 24px;
        }

        .mt-1 {
            margin-top: 1rem;
        }

        .mb-0 {
            margin-bottom: 0px;
        }

        .b-collapse {
            border-collapse: collapse;
        }

        .heading-table-left {
            padding: 6px;
            border: 1px solid #DBDBDB;
            font-weight: bold;
            background-color: #f1f1f3;
            border-right: 0;
        }

        .heading-table-right {
            padding: 6px;
            border: 1px solid #DBDBDB;
            border-left: 0;
        }

        .unpaid {
            color: #000000;
            border: 1px solid #000000;
            position: relative;
            padding: 11px 22px;
            font-size: 15px;
            border-radius: 0.25rem;
            width: 120px;
            text-align: center;
            margin-top: 50px;
        }

        .main-table-heading {
            border: 1px solid #DBDBDB;
            background-color: #f1f1f3;
            font-weight: 700;
        }

        .main-table-heading td {
            padding: 11px 10px;
            border: 1px solid #DBDBDB;
        }

        .main-table-items td {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
        }

        .total-box {
            border: 1px solid #e7e9eb;
            padding: 0px;
            border-bottom: 0px;
        }

        .subtotal {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
        }

        .subtotal-amt {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-right: 0;
        }

        .total {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            font-weight: 700;
            border-left: 0;
        }

        .total-amt {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-right: 0;
            font-weight: 700;
        }

        .balance {
            font-size: 16px;
            font-weight: bold;
            background-color: #f1f1f3;
        }

        .balance-left {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-left: 0;
        }

        .balance-right {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
            border-top: 0;
            border-right: 0;
        }

        .centered {
            margin: 0 auto;
        }

        .rightaligned {
            margin-right: 0;
            margin-left: auto;
        }

        .leftaligned {
            margin-left: 0;
            margin-right: auto;
        }

        .page_break {
            page-break-before: always;
        }

        #logo {
            height: 50px;
        }

        .word-break {
            max-width:175px;
            word-wrap:break-word;
        }

        .summary {
            padding: 11px 10px;
            border: 1px solid #e7e9eb;
        }

        .text-center {
            text-align: center;
        }


    </style>
</head>

<body class="content-wrapper">
    <h3 class="text-center"><?php echo app('translator')->get('app.payment'); ?> <?php echo app('translator')->get('app.receipt'); ?></h3>
    <table class="bg-white" border="0" cellpadding="0" cellspacing="0" width="100%" role="presentation">
        <tbody>
            <!-- Table Row Start -->
            <tr>
                <td>
                    <p class="line-height mt-1 mb-0 f-14 text-black">
                        <?php echo e(company()->company_name); ?><br>
                        <?php if(!is_null($settings) && $payment->invoice && $payment->invoice->address): ?>
                            <?php echo nl2br($payment->invoice->address->address); ?><br>
                        <?php else: ?>
                            <?php echo nl2br(default_address()->address); ?>

                        <?php endif; ?>
                    </p>
                </td>
            </tr>
            <!-- Table Row End -->
            <!-- Table Row Start -->
            <tr>
                <td height="10"></td>
            </tr>
            <!-- Table Row End -->
            <!-- Table Row Start -->
            <tr>
                <td colspan="2">
                    <?php if(!is_null($payment->project)): ?>
                        <?php
                            $client = $payment->project->client;
                        ?>
                    <?php elseif(!is_null($payment->invoice_id) && !is_null($payment->invoice->clientDetails)): ?>
                        <?php
                            $client = $payment->invoice->client;
                        ?>
                    <?php endif; ?>
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <?php if(isset($client)): ?>
                            <td class="f-14 text-black">

                                <p class="line-height mb-0">
                                    <span
                                        class="text-grey text-capitalize"><?php echo app('translator')->get("modules.invoices.billedTo"); ?></span><br>
                                    <?php echo e($client->name); ?><br>
                                    <?php echo e($client->clientDetails->company_name); ?><br>
                                    <?php echo nl2br($client->clientDetails->address); ?>

                                </p>
                            </td>
                            <?php endif; ?>
                            <td align="right">
                                <br />
                                <div class="text-uppercase bg-white unpaid rightaligned">
                                    <?php echo app('translator')->get('app.'.$payment->status); ?>
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>

    <table class="f-14 b-collapse" width="100%">
        <tr>
            <td height="20"></td>
        </tr>
        <tr class="main-table-items">
            <td class="text-grey"><?php echo app('translator')->get("app.amount"); ?></td>
            <td ><?php echo e(currency_format($payment->amount, '')); ?> <?php echo e(($payment->currency ? $payment->currency->currency_code : company()->currency->currency_code)); ?></td>
        </tr>
        <tr class="main-table-items">
            <td class="text-grey"><?php echo app('translator')->get("modules.invoices.paymentMethod"); ?></td>
            <td >
                <?php
                    $method = '--';

                    if(!is_null($payment->offline_method_id)) {
                        $method = $payment->offlineMethod->name;
                    }
                    elseif(isset($payment->gateway)){
                        $method = $payment->gateway;
                    }
                ?>

                <?php echo e($method); ?>

            </td>
        </tr>
        <tr class="main-table-items">
            <td class="text-grey"><?php echo app('translator')->get("app.transactionId"); ?></td>
            <td >
                <?php echo e($payment->transaction_id ?? '--'); ?>

            </td>
        </tr>
        <tr class="main-table-items">
            <td class="text-grey"><?php echo app('translator')->get("modules.invoices.paidOn"); ?></td>
            <td > <?php echo e($payment->paid_on ? $payment->paid_on->translatedFormat(company()->date_format) : '--'); ?> </td>
        </tr>
        <?php if(!is_null($payment->order_id)): ?>
            <tr class="main-table-items">
                <td class="text-grey"><?php echo app('translator')->get("app.order"); ?></td>
                <td > <?php echo e($payment->order->order_number); ?> </td>
            </tr>
        <?php endif; ?>
        <?php if(!is_null($payment->invoice_id)): ?>
            <tr class="main-table-items">
                <td class="text-grey"><?php echo app('translator')->get("app.invoice"); ?></td>
                <td > <?php echo e($payment->invoice->invoice_number); ?> </td>
            </tr>
        <?php endif; ?>
    </table>

</body>

</html>
<?php /**PATH /home/singinn/public_html/indiacrm.singinn.co.in/resources/views/payments/ajax/pdf.blade.php ENDPATH**/ ?>