<?php $__env->startSection('header-section'); ?> <?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="sp-100 login-section" id="section-contact">
        <div class="container">
            <?php if($registrationStatus->registration_open == 1): ?>
                <div class="login-box mt-5 shadow bg-white form-section">
                    <h4 class="mb-0 text-left text-uppercase">
                        <?php echo app('translator')->get('app.signUp'); ?>
                    </h4>
                    <?php echo Form::open(['id'=>'register', 'method'=>'POST']); ?>

                    <div class="row">
                        <div class="col-12">
                            <div id="alert"></div>
                        </div>
                    </div>
                    <div id="form-box">
                        <div class="row">


                            <div class="col-12">
                                <div class="form-group mb-4">
                                    <label for="company_name"><?php echo e(__('modules.client.companyName')); ?></label>
                                    <input type="text" name="company_name" id="company_name"
                                           placeholder="<?php echo e(__('modules.client.companyName')); ?>" class="form-control">
                                </div>
                            </div>
                            <?php if(module_enabled('Subdomain')): ?>
                                <div class="col-12">
                                    <div class="form-group">
                                        <label for="company_name clearfix"><?php echo e(__('subdomain::app.core.subdomain')); ?></label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" placeholder="subdomain"
                                                   name="sub_domain" id="sub_domain">
                                            <div class="input-group-append">
                                                <span class="input-group-text"
                                                      id="basic-addon2">.<?php echo e(getDomain()); ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="row">
                            <div class="col-6">
                                <div class="form-group mb-4">
                                    <label for="email"><?php echo e(__('modules.profile.yourName')); ?></label>
                                    <input type="text" name="name" id="name" placeholder="<?php echo e(__('placeholders.name')); ?>"
                                           class="form-control">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group mb-4">
                                    <label for="email"><?php echo e(__('modules.profile.yourEmail')); ?></label>
                                    <input type="email" name="email" id="email"
                                           placeholder="<?php echo e(__('placeholders.email')); ?>" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="form-group mb-4">
                                    <label for="password"><?php echo e(__('modules.client.password')); ?></label>
                                    <input type="password" class="form-control " id="password" name="password"
                                           placeholder="<?php echo e(__('modules.client.password')); ?>">
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="form-group mb-4">
                                    <label for="password_confirmation"><?php echo e(__('app.confirmPassword')); ?></label>
                                    <input type="password" class="form-control" id="password_confirmation"
                                           name="password_confirmation" placeholder="<?php echo e(__('app.confirmPassword')); ?>">
                                </div>
                            </div>

                            <div class="col-12">
                                <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v2_status == 'active'): ?>
                                    <div class="form-group" id="captcha_container"></div>
                                <?php endif; ?>

                                <input type="hidden" id="g_recaptcha" name="g_recaptcha">

                                <button type="button"
                                        class="btn btn-custom btn-rounded text-uppercase waves-effect waves-light"
                                        id="submit-form">
                                    <?php echo app('translator')->get('app.signUp'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php echo Form::close(); ?>

                </div>
            <?php else: ?>
                <div class="login-box mt-5 form-section register-message">
                    <h5 class="mb-0 text-center">
                        <?php echo $signUpMessage->message; ?>

                    </h5>
                </div>

            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footer-script'); ?>
    <script>

        $('#submit-form').click(function () {

            $.easyAjax({
                url: '<?php echo e(route('front.signup.store')); ?>',
                container: '.form-section',
                type: "POST",
                data: $('#register').serialize(),
                blockUI: true,
                disableButton: true,
                buttonSelector: "#submit-form",
                messagePosition: "inline",

                success: function (response) {
                    if (response.status === 'success') {
                        $('#form-box').remove();
                    } else if (response.status === 'fail') {

                        <?php if($global->google_recaptcha_status): ?>
                        grecaptcha.reset();
                        <?php endif; ?>

                    }
                },
            })

        });
    </script>
    <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v2_status == 'active'): ?>
        <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async
                defer></script>
        <script>
            var gcv3;
            var onloadCallback = function () {
                // Renders the HTML element with id 'captcha_container' as a reCAPTCHA widget.
                // The id of the reCAPTCHA widget is assigned to 'gcv3'.
                gcv3 = grecaptcha.render('captcha_container', {
                    'sitekey': '<?php echo e($global->google_recaptcha_v2_site_key); ?>',
                    'theme': 'light',
                    'callback': function (response) {
                        if (response) {
                            $('#g_recaptcha').val(response);
                        }
                    },
                });
            };
        </script>
    <?php endif; ?>
    <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v3_status == 'active'): ?>
        <script
            src="https://www.google.com/recaptcha/api.js?render=<?php echo e($global->google_recaptcha_v3_site_key); ?>"></script>
        <script>
            grecaptcha.ready(function () {
                grecaptcha.execute('<?php echo e($global->google_recaptcha_v3_site_key); ?>').then(function (token) {
                    // Add your logic to submit to your backend server here.
                    $('#g_recaptcha').val(token);
                });
            });
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('super-admin.layouts.saas-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/singinn/public_html/indiacrm.singinn.co.in/resources/views/super-admin/saas/register.blade.php ENDPATH**/ ?>