<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">


    <title><?php echo app('translator')->get('app.login'); ?> | <?php echo e(ucwords($setting->global_app_name)); ?></title>
    <!-- Favicons -->
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e($global->favicon_url); ?>">
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="msapplication-TileImage" content="<?php echo e($global->favicon_url); ?>">
    <meta name="theme-color" content="#ffffff">

    <!-- Bootstrap CSS -->
    <link type="text/css" rel="stylesheet" media="all"
          href="<?php echo e(asset('saas/vendor/bootstrap/css/bootstrap.min.css')); ?>">
    <link type="text/css" rel="stylesheet" media="all" href="<?php echo e(asset('saas/vendor/animate-css/animate.min.css')); ?>">
    <link type="text/css" rel="stylesheet" media="all" href="<?php echo e(asset('saas/vendor/slick/slick.css')); ?>">
    <link type="text/css" rel="stylesheet" media="all" href="<?php echo e(asset('saas/vendor/slick/slick-theme.css')); ?>">
    <link type="text/css" rel="stylesheet" media="all" href="<?php echo e(asset('saas/fonts/flaticon/flaticon.css')); ?>">
    <link href="<?php echo e(asset('front/plugin/froiden-helper/helper.css')); ?>" rel="stylesheet">
    <!-- Template CSS -->
    <link type="text/css" rel="stylesheet" media="all" href="<?php echo e(asset('saas/css/main.css')); ?>">
    <!-- Template Font Family  -->
    <link
        href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;600;700&family=Rubik:wght@400;500&display=swap"
        rel="stylesheet">
    <link type="text/css" rel="stylesheet" media="all"
          href="<?php echo e(asset('saas/vendor/material-design-iconic-font/css/material-design-iconic-font.min.css')); ?>">

    <?php if($global->google_recaptcha_status  && $global->google_captcha_version=="v3"): ?>
        <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e($global->google_recaptcha_key); ?>"></script>

        <script>
            setInterval(function () {

                grecaptcha.ready(function () {
                    grecaptcha.execute('<?php echo e($global->google_recaptcha_key); ?>', {action: 'submit'}).then(function (token) {
                        document.getElementById("recaptcha_token").value = token;
                    });
                });

            }, 3000);

        </script>
    <?php endif; ?>

    <style>
        <?php echo $setting->auth_css_theme_two; ?>


        :root {
            --main-color: <?php echo e($frontDetail->primary_color); ?>;
        }

        .help-block {
            color: #8a1f11 !important;
        }

        @media (max-width: 767px) {
            .login-box form {
                padding: 10px;
            }

            .input-group-text {
                font-size: 13px;
            }

            .login-box h5 {
                padding: 35px 15px 15px;
                font-size: 21px;
                text-align: center;
                font-weight: 600;
            }
        }
        .spinner-border{
            margin-bottom: 4px;
        }

    </style>
    <?php if(isset($socialAuthSettings) && (in_array('enabled',[$socialAuthSettings->facebook_status,$socialAuthSettings->google_status,$socialAuthSettings->twitter_status,$socialAuthSettings->linkedin_status]))): ?>
        <?php
            $socialLogin = true;
        ?>
    <?php else: ?>
        <?php
            $socialLogin = false;
        ?>
    <?php endif; ?>

    <?php if($socialLogin): ?>
        <style>
            .login-box {
                max-width: 900px
            }
        </style>
    <?php endif; ?>

</head>

<body id="home">


<!-- Topbar -->
<?php echo $__env->make('super-admin.sections.saas.saas_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- END Topbar -->

<!-- Header -->
<!-- END Header -->


<section class="sp-100 login-section" id="section-contact">
    <div class="container">
        <div class="login-box mt-5 shadow bg-white form-section row align-items-center">

            <div class="<?php if($socialLogin): ?> col-lg-6 <?php else: ?> col-lg-12 <?php endif; ?> order-lg-1" id="form-box">
                <h4 class="mb-0">
                    <?php echo app('translator')->get('app.login'); ?>
                </h4>

                <form class="form-horizontal form-material" id="save-form" action="<?php echo e(route('login')); ?>" method="POST">
                    <?php echo e(csrf_field()); ?>



                    <?php if(session('message')): ?>
                        <div class="alert alert-danger m-t-10">
                            <?php echo e(session('message')); ?>

                        </div>
                    <?php endif; ?>

                    <div class="form-group <?php echo e($errors->has('email') ? 'has-error' : ''); ?>">
                        <div class="col-xs-12">
                            <input class="form-control" id="email" type="email" name="email" value="<?php echo e(old('email')); ?>"
                                   autofocus required="" placeholder="<?php echo app('translator')->get('app.email'); ?>">
                            <?php if($errors->has('email')): ?>
                                <div class="help-block with-errors"><?php echo e($errors->first('email')); ?></div>
                            <?php endif; ?>

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-xs-12">
                            <input class="form-control" id="password" type="password" name="password" required=""
                                   placeholder="<?php echo app('translator')->get('modules.client.password'); ?>">
                            <?php if($errors->has('password')): ?>
                                <div class="help-block with-errors"><?php echo e($errors->first('password')); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v2_status == 'active'): ?>
                        <div class="form-group" id="captcha_container"></div>
                    <?php endif; ?>
                    <?php if($errors->has('g-recaptcha-response')): ?>
                        <div class="help-block with-errors"><?php echo e($errors->first('g-recaptcha-response')); ?>

                        </div>
                    <?php endif; ?>

                    <input type="hidden" id="g_recaptcha" name="g_recaptcha">

                    <div class="form-group">
                        <div class="col-xs-12">
                            <div class="checkbox checkbox-primary float-left p-t-0">
                                <input id="checkbox-signup" type="checkbox"
                                       name="remember" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                <label for="checkbox-signup" class="text-dark"> <?php echo app('translator')->get('app.rememberMe'); ?> </label>
                            </div>
                            <a href="<?php echo e(route('password.request')); ?>" class="text-dark float-right"><i
                                    class="fa fa-lock m-r-5"></i> <?php echo app('translator')->get('app.forgotPassword'); ?>?</a></div>
                    </div>
                    <div class="form-group text-center m-t-20">
                        <div class="col-xs-12">
                            <button
                                class="btn btn-custom btn-block btn-rounded text-uppercase waves-effect waves-light"
                                id="submit-login"
                                type="submit"><?php echo app('translator')->get('app.login'); ?></button>
                        </div>
                    </div>
                    <?php if($setting->enable_register == true): ?>
                        <div class="form-group m-b-0">
                            <div class="col-sm-12 text-center">
                                <p><?php echo app('translator')->get('superadmin.dontHaveAccount'); ?><br>
                                    <a href="<?php echo e(route('front.signup.index')); ?>"
                                                                             class="text-primary m-l-5"><b><?php echo app('translator')->get('app.signUp'); ?></b></a>
                                </p>
                            </div>
                            <?php endif; ?>
                        </div>
                </form>
            </div>

            <script>
                const facebook = "<?php echo e(route('social_login', 'facebook')); ?>";
                const google = "<?php echo e(route('social_login', 'google')); ?>";
                const twitter = "<?php echo e(route('social_login', 'twitter')); ?>";
                const linkedin = "<?php echo e(route('social_login', 'linkedin')); ?>";
            </script>
            <?php if(isset($socialAuthSettings) && (in_array('enable',[$socialAuthSettings->facebook_status,$socialAuthSettings->google_status,$socialAuthSettings->twitter_status,$socialAuthSettings->linkedin_status]))): ?>
                <div class=" order-lg-2 ">
                    <div class="row  align-items-center">

                        <div class="col-xs-12 col-sm-12  text-center mb-2">
                            <?php if($socialAuthSettings->facebook_status == 'enable'): ?>
                                <a href="javascript:;" class="btn btn-primary btn-facebook" data-toggle="tooltip"
                                   title="<?php echo app('translator')->get('auth.signInFacebook'); ?>" onclick="window.location.href = facebook;"
                                   data-original-title="<?php echo app('translator')->get('auth.signInFacebook'); ?>"><?php echo app('translator')->get('auth.signInFacebook'); ?>
                                    <i aria-hidden="true" class="zmdi zmdi-facebook"></i> </a>
                            <?php endif; ?>
                        </div>
                        <div class="col-xs-12 col-sm-12 m-t-10 text-center mb-2">
                            <?php if($socialAuthSettings->google_status == 'enable'): ?>

                                <a href="javascript:;" class="btn btn-primary btn-google" data-toggle="tooltip"
                                   title="<?php echo app('translator')->get('auth.loginWithGoogle'); ?>" onclick="window.location.href = google;"
                                   data-original-title="<?php echo app('translator')->get('auth.loginWithGoogle'); ?>"><?php echo app('translator')->get('auth.signInGoogle'); ?> <i
                                        aria-hidden="true" class="zmdi zmdi-google"></i> </a>
                            <?php endif; ?>
                        </div>
                        <div class="col-xs-12 col-sm-12  m-t-10 text-center mb-2">
                            <?php if($socialAuthSettings->twitter_status == 'enable'): ?>
                                <a href="javascript:;" class="btn btn-primary btn-twitter" data-toggle="tooltip"
                                   title="<?php echo app('translator')->get('auth.signInTwitter'); ?>" onclick="window.location.href = twitter;"
                                   data-original-title="<?php echo app('translator')->get('auth.signInTwitter'); ?>"><?php echo app('translator')->get('auth.signInTwitter'); ?> <i
                                        aria-hidden="true" class="zmdi zmdi-twitter"></i> </a>
                            <?php endif; ?>
                        </div>
                        <div class="col-xs-12 col-sm-12 m--10 text-center mb-lg-4">
                            <?php if($socialAuthSettings->linkedin_status == 'enable'): ?>
                                <a href="javascript:;" class="btn btn-primary btn-linkedin" data-toggle="tooltip"
                                   title="<?php echo app('translator')->get('auth.signInLinkedin'); ?>" onclick="window.location.href = linkedin;"
                                   data-original-title="<?php echo app('translator')->get('auth.signInLinkedin'); ?>"><?php echo app('translator')->get('auth.signInLinkedin'); ?>
                                    <i aria-hidden="true" class="zmdi zmdi-linkedin"></i> </a>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- END Main container -->

<!-- Cta -->

<!-- End Cta -->

<!-- Footer -->
<?php echo $__env->make('super-admin.sections.saas.saas_footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- END Footer -->


<!-- Scripts -->
<script src="<?php echo e(asset('saas/vendor/jquery/jquery.min.js')); ?>"></script>
<script src="<?php echo e(asset('saas/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset('saas/vendor/slick/slick.min.js')); ?>"></script>
<script src="<?php echo e(asset('saas/vendor/wowjs/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('front/plugin/froiden-helper/helper.js')); ?>"></script>
<script src="<?php echo e(asset('saas/js/main.js')); ?>"></script>
<script src="<?php echo e(asset('front/plugin/froiden-helper/helper.js')); ?>"></script>
<!-- Global Required JS -->

<script>
    $("form#save-form").submit(function () {
        const button = $('form#save-form').find('#submit-login');

        const text = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> <?php echo e(__('app.loading')); ?>';

        button.prop("disabled", true);
        button.html(text);
    });
</script>
<?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v2_status == 'active'): ?>
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async
            defer></script>
    <script>
        var gcv3;
        var onloadCallback = function () {
            // Renders the HTML element with id 'captcha_container' as a reCAPTCHA widget.
            // The id of the reCAPTCHA widget is assigned to 'gcv3'.
            gcv3 = grecaptcha.render('captcha_container', {
                'sitekey': '<?php echo e($global->google_recaptcha_v2_site_key); ?>',
                'theme': 'light',
                'callback': function (response) {
                    if (response) {
                        $('#g_recaptcha').val(response);
                    }
                },
            });
        };
    </script>
<?php endif; ?>
<?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v3_status == 'active'): ?>
    <script
        src="https://www.google.com/recaptcha/api.js?render=<?php echo e($global->google_recaptcha_v3_site_key); ?>"></script>
    <script>
        grecaptcha.ready(function () {
            grecaptcha.execute('<?php echo e($global->google_recaptcha_v3_site_key); ?>').then(function (token) {
                // Add your logic to submit to your backend server here.
                $('#g_recaptcha').val(token);
            });
        });
    </script>
<?php endif; ?>

</body>
</html>
<?php /**PATH /home/singinn/public_html/indiacrm.singinn.co.in/resources/views/super-admin/saas/login.blade.php ENDPATH**/ ?>