<?php
$addLeadPermission = user()->permission('add_lead');
$manageStatusPermission = user()->permission('manage_lead_status');
$changeStatusPermission = user()->permission('change_lead_status');
?>

<?php $__currentLoopData = $result['boardColumns']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $column): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
     <?php if($column->userSetting && $column->userSetting->collapsed): ?>
         <!-- MINIMIZED BOARD PANEL START -->
         <div class="minimized rounded bg-additional-grey border-grey mr-3">
             <!-- TASK BOARD HEADER START -->
             <div class="d-flex mt-4 mx-1 b-p-header align-items-center">
                 <a href="javascript:;" class="d-grid f-8 mb-3 text-lightest collapse-column"
                     data-column-id="<?php echo e($column->id); ?>" data-type="maximize" data-toggle="tooltip" data-original-title=<?php echo app('translator')->get('app.expand'); ?>>
                     <i class="fa fa-chevron-right ml-1"></i>
                     <i class="fa fa-chevron-left"></i>
                 </a>

                 <p class="mb-3 mx-0 f-15 text-dark-grey font-weight-bold"><i class="fa fa-circle mb-2 text-red"
                         style="color: <?php echo e($column->label_color); ?>"></i><?php echo e(mb_ucwords($column->type)); ?>

                </p>

                 <span class="b-p-badge bg-grey f-13 px-2 py-2 text-lightest font-weight-bold rounded d-inline-block" id="lead-column-count-<?php echo e($column->id); ?>"><?php echo e($column->leads_count); ?></span>

             </div>
             <!-- TASK BOARD HEADER END -->

         </div>
         <!-- MINIMIZED BOARD PANEL END -->
     <?php else: ?>
         <!-- BOARD PANEL 2 START -->
         <div class="board-panel rounded bg-additional-grey border-grey mr-3">
             <!-- TASK BOARD HEADER START -->
             <div class="mx-3 mt-3 mb-1 b-p-header">
                <div class="d-flex">
                 <p class="mb-0 f-15 mr-3 text-dark-grey font-weight-bold"><i class="fa fa-circle mr-2 text-yellow"
                         style="color: <?php echo e($column->label_color); ?>"></i><?php echo e(mb_ucwords($column->type)); ?>

                 </p>

                 <span
                     class="b-p-badge bg-grey f-13 px-2 text-lightest font-weight-bold rounded d-inline-block" id="lead-column-count-<?php echo e($column->id); ?>"><?php echo e($column->leads_count); ?></span>
                
                 <span class="ml-auto d-flex align-items-center">

                     <a href="javascript:;" class="d-flex f-8 text-lightest mr-3 collapse-column"
                         data-column-id="<?php echo e($column->id); ?>" data-type="minimize" data-toggle="tooltip" data-original-title=<?php echo app('translator')->get('app.collapse'); ?>>
                         <i class="fa fa-chevron-right mr-1"></i>
                         <i class="fa fa-chevron-left"></i>
                     </a>
                    <?php if($addLeadPermission != 'none' || $manageStatusPermission == 'all'): ?>

                        <div class="dropdown">
                            <button
                                class="btn bg-white btn-lg f-10 px-2 py-1 text-dark-grey text-capitalize rounded  dropdown-toggle"
                                type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                aria-expanded="false">
                                <i class="fa fa-ellipsis-h"></i>
                            </button>

                            <div class="dropdown-menu dropdown-menu-right border-grey rounded b-shadow-4 p-0"
                                aria-labelledby="dropdownMenuLink" tabindex="0">
                                <?php if($addLeadPermission != 'none'): ?>
                                    <a class="dropdown-item openRightModal"
                                        href="<?php echo e(route('leads.create')); ?>?column_id=<?php echo e($column->id); ?>"><?php echo app('translator')->get('app.add'); ?>
                                        <?php echo app('translator')->get('app.lead'); ?></a>
                                    <?php endif; ?>
                                <?php if($manageStatusPermission == 'all'): ?>
                                    <hr class="my-1">
                                     <a class="dropdown-item edit-column"
                                    data-column-id="<?php echo e($column->id); ?>" href="javascript:;"><?php echo app('translator')->get('app.edit'); ?></a>
                                <?php endif; ?>

                                <?php if(!$column->default && $manageStatusPermission == 'all'): ?>
                                    <a class="dropdown-item delete-column"
                                        data-column-id="<?php echo e($column->id); ?>" href="javascript:;"><?php echo app('translator')->get('app.delete'); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>

                 </span>
                </div>
                
                <div class="mr-3 ml-4 f-11 text-dark-grey"><?php echo e(currency_format($column->total_value)); ?></div>
             </div>

             <!-- TASK BOARD HEADER END -->

             <!-- TASK BOARD BODY START -->
             <div class="b-p-body">
                 <!-- MAIN TASKS START -->
                 <div class="b-p-tasks" id="drag-container-<?php echo e($column->id); ?>" data-column-id="<?php echo e($column->id); ?>">
                    <div class="card rounded bg-white border-grey b-shadow-4 m-1 mb-3 no-task-card move-disable <?php echo e(($column->leads_count > 0 ) ? 'd-none' : ''); ?>">
                        <div class="card-body">
                            <div class="d-flex justify-content-center py-3">
                                <p class="mb-0">
                                    <a href="<?php echo e(route('leads.create')); ?>?column_id=<?php echo e($column->id); ?>"
                                        class="text-dark-grey openRightModal"><i
                                            class="fa fa-plus mr-2"></i><?php echo app('translator')->get('app.add'); ?> <?php echo app('translator')->get('app.lead'); ?></a>
                                </p>
                            </div>
                        </div>
                    </div><!-- div end -->

                    <?php $__currentLoopData = $column['leads']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <?php if (isset($component)) { $__componentOriginal883d60c7bd09cc05e7b0f15847cdeb1b03393595 = $component; } ?>
<?php $component = App\View\Components\Cards\LeadCard::resolve(['draggable' => ($changeStatusPermission == 'all') ? 'true' : 'false','lead' => $lead] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('cards.lead-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Cards\LeadCard::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal883d60c7bd09cc05e7b0f15847cdeb1b03393595)): ?>
<?php $component = $__componentOriginal883d60c7bd09cc05e7b0f15847cdeb1b03393595; ?>
<?php unset($__componentOriginal883d60c7bd09cc05e7b0f15847cdeb1b03393595); ?>
<?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
     <!-- MAIN TASKS END -->
     <?php if($column->leads_count > count($column['leads'])): ?>
         <!-- TASK BOARD FOOTER START -->
         <div class="d-flex m-3 justify-content-center">
             <a class="f-13 text-dark-grey f-w-500 load-more-tasks" data-column-id="<?php echo e($column->id); ?>"
                 data-total-tasks="<?php echo e($column->leads_count); ?>"
                 href="javascript:;"><?php echo app('translator')->get('modules.tasks.loadMore'); ?></a>
         </div>
         <!-- TASK BOARD FOOTER END -->
     <?php endif; ?>
     </div>
     <!-- TASK BOARD BODY END -->
     </div>
     <!-- BOARD PANEL 2 END -->
 <?php endif; ?>

 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

 <!-- Drag and Drop Plugin -->
 <script>
     var arraylike = document.getElementsByClassName('b-p-tasks');
     var containers = Array.prototype.slice.call(arraylike);
     var drake = dragula({
             containers: containers,
             moves: function(el, source, handle, sibling) {
                 if (el.classList.contains('move-disable') || !KTUtil.isDesktopDevice()) {
                     return false;
                 }

                 return true; // elements are always draggable by default
             },
         })
         .on('drag', function(el) {
             el.className = el.className.replace('ex-moved', '');
         }).on('drop', function(el) {
             el.className += ' ex-moved';
         }).on('over', function(el, container) {
             container.className += ' ex-over';
         }).on('out', function(el, container) {
             container.className = container.className.replace('ex-over', '');
         });

 </script>

 <script>
     drake.on('drop', function(element, target, source, sibling) {
         var elementId = element.id;
         $children = $('#' + target.id).children();
         var boardColumnId = $('#' + target.id).data('column-id');
         var movingTaskId = $('#' + element.id).data('task-id');
         var sourceBoardColumnId = $('#' + source.id).data('column-id');
         var sourceColumnCount = parseInt($('#lead-column-count-' + sourceBoardColumnId).text());
         var targetColumnCount = parseInt($('#lead-column-count-' + boardColumnId).text());

         var taskIds = [];
         var prioritys = [];

         $children.each(function(ind, el) {
             taskIds.push($(el).data('task-id'));
             prioritys.push($(el).index());
         });

         // update values for all tasks
         $.easyAjax({
             url: "<?php echo e(route('leadboards.update_index')); ?>",
             type: 'POST',
             container: '#taskboard-columns',
             blockUI: true,
             data: {
                 boardColumnId: boardColumnId,
                 movingTaskId: movingTaskId,
                 taskIds: taskIds,
                 prioritys: prioritys,
                 '_token': '<?php echo e(csrf_token()); ?>'
             },
             success: function() {
                if ($('#' + source.id + ' .task-card').length == 0) {
                    $('#' + source.id + ' .no-task-card').removeClass('d-none');
                }
                if ($('#' + target.id + ' .task-card').length > 0) {
                    $('#' + target.id + ' .no-task-card').addClass('d-none');
                }

                $('#lead-column-count-' + sourceBoardColumnId).text(sourceColumnCount - 1);
                $('#lead-column-count-' + boardColumnId).text(targetColumnCount + 1);

             }
         });

     });

 </script>
<?php /**PATH /home/singinn/public_html/indiacrm.singinn.co.in/resources/views/leads/board/board_data.blade.php ENDPATH**/ ?>