<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudSearch;

class ContextualAddOnMarkup extends \Google\Collection
{
  protected $collection_key = 'cards';
  protected $cardsType = Card::class;
  protected $cardsDataType = 'array';
  public $cards = [];
  protected $toolbarType = Toolbar::class;
  protected $toolbarDataType = '';
  public $toolbar;

  /**
   * @param Card[]
   */
  public function setCards($cards)
  {
    $this->cards = $cards;
  }
  /**
   * @return Card[]
   */
  public function getCards()
  {
    return $this->cards;
  }
  /**
   * @param Toolbar
   */
  public function setToolbar(Toolbar $toolbar)
  {
    $this->toolbar = $toolbar;
  }
  /**
   * @return Toolbar
   */
  public function getToolbar()
  {
    return $this->toolbar;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ContextualAddOnMarkup::class, 'Google_Service_CloudSearch_ContextualAddOnMarkup');
