<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contactcenterinsights;

class GoogleCloudContactcenterinsightsV1ListIssueModelsResponse extends \Google\Collection
{
  protected $collection_key = 'issueModels';
  protected $issueModelsType = GoogleCloudContactcenterinsightsV1IssueModel::class;
  protected $issueModelsDataType = 'array';
  public $issueModels = [];

  /**
   * @param GoogleCloudContactcenterinsightsV1IssueModel[]
   */
  public function setIssueModels($issueModels)
  {
    $this->issueModels = $issueModels;
  }
  /**
   * @return GoogleCloudContactcenterinsightsV1IssueModel[]
   */
  public function getIssueModels()
  {
    return $this->issueModels;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudContactcenterinsightsV1ListIssueModelsResponse::class, 'Google_Service_Contactcenterinsights_GoogleCloudContactcenterinsightsV1ListIssueModelsResponse');
