<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Games;

class AchievementUpdateMultipleResponse extends \Google\Collection
{
  protected $collection_key = 'updatedAchievements';
  /**
   * @var string
   */
  public $kind;
  protected $updatedAchievementsType = AchievementUpdateResponse::class;
  protected $updatedAchievementsDataType = 'array';
  public $updatedAchievements = [];

  /**
   * @param string
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param AchievementUpdateResponse[]
   */
  public function setUpdatedAchievements($updatedAchievements)
  {
    $this->updatedAchievements = $updatedAchievements;
  }
  /**
   * @return AchievementUpdateResponse[]
   */
  public function getUpdatedAchievements()
  {
    return $this->updatedAchievements;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AchievementUpdateMultipleResponse::class, 'Google_Service_Games_AchievementUpdateMultipleResponse');
