<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ToolResults;

class ShardSummary extends \Google\Collection
{
  protected $collection_key = 'runs';
  protected $runsType = StepSummary::class;
  protected $runsDataType = 'array';
  public $runs = [];
  protected $shardResultType = MergedResult::class;
  protected $shardResultDataType = '';
  public $shardResult;

  /**
   * @param StepSummary[]
   */
  public function setRuns($runs)
  {
    $this->runs = $runs;
  }
  /**
   * @return StepSummary[]
   */
  public function getRuns()
  {
    return $this->runs;
  }
  /**
   * @param MergedResult
   */
  public function setShardResult(MergedResult $shardResult)
  {
    $this->shardResult = $shardResult;
  }
  /**
   * @return MergedResult
   */
  public function getShardResult()
  {
    return $this->shardResult;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShardSummary::class, 'Google_Service_ToolResults_ShardSummary');
